VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   10155
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   12180
   LinkTopic       =   "Form1"
   ScaleHeight     =   10155
   ScaleWidth      =   12180
   StartUpPosition =   3  'Windows ⺻
   Begin VB.ListBox lbxLog 
      Height          =   1140
      Left            =   120
      TabIndex        =   18
      Top             =   8880
      Width           =   11895
   End
   Begin VB.CheckBox chkReportRssi 
      Caption         =   "RSSI"
      Height          =   255
      Left            =   120
      TabIndex        =   17
      Top             =   7800
      Width           =   1335
   End
   Begin VB.CheckBox chkContinuous 
      Caption         =   "Continuous"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   7440
      Width           =   1335
   End
   Begin VB.CheckBox chkLed 
      Caption         =   "LED"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      Top             =   6960
      Width           =   1215
   End
   Begin VB.CheckBox chkVibrate 
      Caption         =   "Vibrate"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   6600
      Width           =   1215
   End
   Begin VB.CheckBox chkBeep 
      Caption         =   "Beep"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   6240
      Width           =   1215
   End
   Begin VB.CheckBox chkUseKey 
      Caption         =   "Use Key"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   5760
      Width           =   1215
   End
   Begin VB.TextBox txtSerial 
      Height          =   270
      Left            =   120
      TabIndex        =   11
      Top             =   5160
      Width           =   2535
   End
   Begin VB.TextBox txtVersion 
      Height          =   270
      Left            =   120
      TabIndex        =   9
      Top             =   4440
      Width           =   2535
   End
   Begin VB.ListBox lbxData 
      Height          =   8700
      Left            =   2760
      TabIndex        =   7
      Top             =   120
      Width           =   9255
   End
   Begin VB.CommandButton btnClear 
      Caption         =   "Clear"
      Height          =   615
      Left            =   120
      TabIndex        =   6
      Top             =   3360
      Width           =   2535
   End
   Begin VB.CommandButton btnBarcode 
      Caption         =   "Barcode"
      Height          =   615
      Left            =   120
      TabIndex        =   5
      Top             =   2640
      Width           =   2535
   End
   Begin VB.CommandButton btnInventory 
      Caption         =   "Inventory"
      Height          =   615
      Left            =   120
      TabIndex        =   4
      Top             =   1920
      Width           =   2535
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Height          =   615
      Left            =   120
      TabIndex        =   3
      Top             =   1200
      Width           =   2535
   End
   Begin VB.CommandButton btnOpen 
      Caption         =   "Open"
      Height          =   615
      Left            =   120
      TabIndex        =   2
      Top             =   480
      Width           =   2535
   End
   Begin VB.ComboBox cbxPort 
      Height          =   300
      Left            =   1440
      TabIndex        =   1
      Text            =   "Combo1"
      Top             =   120
      Width           =   1215
   End
   Begin VB.ComboBox cbxReader 
      Height          =   300
      Left            =   120
      TabIndex        =   0
      Text            =   "Combo1"
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblCount 
      Alignment       =   2  ' 
      Caption         =   "0"
      BeginProperty Font 
         Name            =   ""
         Size            =   18
         Charset         =   129
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   120
      TabIndex        =   19
      Top             =   8280
      Width           =   2535
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Serial Number"
      Height          =   180
      Left            =   120
      TabIndex        =   10
      Top             =   4920
      Width           =   1215
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "System Version"
      Height          =   180
      Left            =   120
      TabIndex        =   8
      Top             =   4200
      Width           =   1350
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private WithEvents reader As AtidReader
Attribute reader.VB_VarHelpID = -1

Private cntTotal As Integer

Private Sub btnBarcode_Click()
    Dim result As ResultCode
    If reader.GetReaderType() = ReaderType_ATD100 Then
        Call appendLog("Not supported.")
        Exit Sub
    End If

    If reader.GetAction() = ActionState_Stop Then
        result = reader.StartDecode
    Else
        result = reader.StopDecode
    End If
    
    If result <> ResultCode_NoError Then
        Call appendLog("Error : " + CStr(result))
    End If
End Sub

Private Sub btnClear_Click()
    Call lbxData.Clear
    cntTotal = 0
    lblCount.Caption = CStr(cntTotal)
End Sub

Private Sub btnInventory_Click()
    Dim result As ResultCode
    If reader.GetAction() = ActionState_Stop Then
        result = reader.Inventory6C
    Else
        result = reader.StopUhfOperation
    End If
        
    If result <> ResultCode_NoError Then
        Call appendLog("Error : " + CStr(result))
    End If
    
End Sub

Private Sub btnClose_Click()
    Call reader.Close
End Sub

Private Sub btnOpen_Click()

    Dim readerType, result
    
    Select Case cbxReader.ListIndex
        Case 0
            readerType = ReaderType_AT188N
        Case 1
            readerType = ReaderType_AT388
        Case 2
            readerType = ReaderType_ATS100
        Case 3
            readerType = ReaderType_ATD100
    End Select
    
    
    result = reader.Open(readerType, ConnectType_VCP, cbxPort.Text)
    Call appendLog("Open : " + CStr(result))
    
End Sub

Private Sub appendLog(ByVal log As String)
    Call lbxLog.AddItem(log)
    lbxLog.ListIndex = lbxLog.ListCount - 1
    
End Sub

Private Sub enableCheckBox()
    If reader.GetAction() = ActionState_Stop And reader.GetConnectionState() = ConnectionState_Connected Then
        chkUseKey.Enabled = True
        chkBeep.Enabled = True
        chkVibrate.Enabled = True
        chkLed.Enabled = True
        chkContinuous.Enabled = True
        chkReportRssi.Enabled = True
    Else
        chkUseKey.Enabled = False
        chkBeep.Enabled = False
        chkVibrate.Enabled = False
        chkLed.Enabled = False
        chkContinuous.Enabled = False
        chkReportRssi.Enabled = False
    End If
    
End Sub

Private Sub enableButton()
    If reader.GetConnectionState() = ConnectionState_Connected Then
        Select Case reader.GetAction()
        Case ActionState.ActionState_Inventory6c
            btnOpen.Enabled = False
            btnClose.Enabled = False
            btnBarcode.Enabled = False
            btnClear.Enabled = False
            btnInventory.Caption = "Stop"
        Case ActionState.ActionState_Decoding
            btnOpen.Enabled = False
            btnClose.Enabled = False
            btnInventory.Enabled = False
            btnClear.Enabled = False
            btnBarcode.Caption = "Stop"
        Case ActionState.ActionState_Stop
            btnOpen.Enabled = True
            btnClose.Enabled = True
            btnClear.Enabled = True
            btnInventory.Caption = "Inventory"
            btnInventory.Enabled = True
            btnBarcode.Caption = "Barcode"
            btnBarcode.Enabled = True
        End Select
    Else
        btnOpen.Enabled = True
        btnClose.Enabled = True
        btnInventory.Enabled = False
        btnBarcode.Enabled = False
        btnClear.Enabled = False
        cbxReader.Enabled = True
        cbxPort.Enabled = True
    End If
End Sub

Private Function isReady() As Boolean
    isReady = IIf(reader.GetConnectionState() = ConnectionState_Connected And reader.GetAction() = ActionState_Stop, True, False)
End Function

Private Sub chkReportRssi_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    result = reader.SetEnableReportRssi(IIf(chkReportRssi.Value > 0, True, False))
    If result <> ResultCode_NoError Then
        Call appendLog("SetEnableReportRssi Error : " + CStr(result))
    End If
End Sub

Private Sub chkContinuous_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    result = reader.SetEnableContinuousMode(IIf(chkContinuous.Value > 0, True, False))
    If result <> ResultCode_NoError Then
        Call appendLog("SetEnableContinuousMode Error : " + CStr(result))
    End If
End Sub

Private Sub chkLed_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    Set noti = reader.GetAlertNotify
    Call noti.setMethods(NotifyType.NotifyType_Light, IIf(chkLed.Value > 0, True, False))
    result = reader.SetAlertNotify(noti)
    If result <> ResultCode_NoError Then
        Call appendLog("SetAlertNotify(LED) Error : " + CStr(result))
    End If
End Sub



Private Sub chkVibrate_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    Set noti = reader.GetAlertNotify
    Call noti.setMethods(NotifyType.NotifyType_Vibrate, IIf(chkVibrate.Value > 0, True, False))
    result = reader.SetAlertNotify(noti)
    If result <> ResultCode_NoError Then
        Call appendLog("SetAlertNotify(vibrate) Error : " + CStr(result))
    End If
    
End Sub

Private Sub chkBeep_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    Set noti = reader.GetAlertNotify
    Call noti.setMethods(NotifyType.NotifyType_Beep, IIf(chkBeep.Value > 0, True, False))
    result = reader.SetAlertNotify(noti)
    If result <> ResultCode_NoError Then
        Call appendLog("SetAlertNotify(beep) Error : " + CStr(result))
    End If
    
End Sub

Private Sub chkUseKey_Click()
    Dim result As ResultCode
    
    If isReady = False Then
        Exit Sub
    End If
    
    If reader.GetReaderType() = ReaderType_ATD100 Then
        Call appendLog("Not supported.")
    Else
        result = reader.SetEnableActionKey(IIf(chkUseKey.Value > 0, True, False))
        If result <> ResultCode_NoError Then
            Call appendLog("SetEnableActionKey Error : " + CStr(result))
        End If
    End If
    
End Sub



Private Sub Form_Load()
    Me.Caption = "ATID Reader Interop Test"
    Call cbxReader.AddItem("AT188N")
    Call cbxReader.AddItem("AT388")
    Call cbxReader.AddItem("ATS100")
    Call cbxReader.AddItem("ATD100")
    cbxReader.ListIndex = 0

    For i = 0 To 99
        Call cbxPort.AddItem("COM" + CStr(i))
    Next
    cbxPort.Text = "COM15"
    
    Set reader = New AtidReader
    Call enableButton
    Call enableCheckBox
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call reader.Dispose
End Sub

Private Sub reader_OnBarcodeDecodeData(ByVal BarcodeType As AtidReader_Interop.BarcodeType, ByVal barcodeId As String, ByVal barcodeData As String)
    Call lbxData.AddItem("Type:" + CStr(BarcodeType) + " Data:" + barcodeData)
    cntTotal = cntTotal + 1
    lblCount.Caption = CStr(cntTotal)
End Sub

Private Sub reader_OnRfidUhfInventory(ByVal epc As String, ByVal rssi As Single, ByVal phase As Single, ByVal frequency As Single)
    If chkReportRssi.Value > 0 Then
        Call lbxData.AddItem(epc + ", " + CStr(rssi))
    Else
        Call lbxData.AddItem(epc)
    End If
    cntTotal = cntTotal + 1
    lblCount.Caption = CStr(cntTotal)
End Sub

Private Sub reader_OnSystemAction(ByVal ResultCode As AtidReader_Interop.ResultCode, ByVal ActionState As AtidReader_Interop.ActionState)
    If ActionState = ActionState_Inventory6c Then
        Call appendLog("Action : Inventory6c")
    ElseIf ActionState = ActionState_Decoding Then
        Call appendLog("Action : Decoding")
    ElseIf ActionState = ActionState_Stop Then
        Call appendLog("Action : Stop")
    End If
    
    Call enableButton
    Call enableCheckBox
End Sub

Private Sub reader_OnSystemConnectionState(ByVal connectState As AtidReader_Interop.ConnectionState)
    Dim noti As NotifyMethod

    If connectState = ConnectionState_Connected Then
        If reader.GetReaderType() <> ReaderType_ATD100 Then
            chkUseKey.Value = IIf(reader.GetEnableActionKey() = True, 1, 0)
        End If
        
        Set noti = reader.GetAlertNotify
        chkBeep.Value = IIf(noti.getMethod(NotifyType.NotifyType_Beep) = True, 1, 0)
        chkVibrate.Value = IIf(noti.getMethod(NotifyType.NotifyType_Vibrate) = True, 1, 0)
        chkLed.Value = IIf(noti.getMethod(NotifyType.NotifyType_Light) = True, 1, 0)
        chkContinuous.Value = IIf(reader.GetEnableContinuousMode = True, 1, 0)
        chkReportRssi.Value = IIf(reader.GetEnableReportRssi = True, 1, 0)
        txtVersion.Text = reader.GetSystemVersion()
        txtSerial.Text = reader.GetSerialNumber()
        Call enableButton
        Call enableCheckBox
        Call appendLog("Connectivity : Connected")
    ElseIf connectState = ConnectionState_Disconnected Then
        chkUseKey.Value = 0
        chkBeep.Value = 0
        chkVibrate.Value = 0
        chkLed.Value = 0
        chkContinuous.Value = 0
        chkReportRssi.Value = 0
        txtVersion.Text = ""
        txtSerial.Text = ""
        Call enableButton
        Call enableCheckBox
        Call appendLog("Connectivity : Disconnected")
    ElseIf connectState = ConnectionState_Connecting Then
        Call appendLog("Connectivity : Connecting")
    End If
End Sub

Private Sub reader_OnSystemTriggerMode(ByVal TriggerMode As AtidReader_Interop.TriggerMode)
    appendLog ("Trigger : " + CStr(TriggerMode))
End Sub
